#include <iostream>
#include <vector>
#include <algorithm>
#include <map>
#include <cstdint>

using namespace std;

int64_t xor_div(int64_t i, const vector<int64_t> & pdivs);

int main()
{
    int64_t n;
    int64_t k;
    cin >> n;
    cin >> k;
    vector<int64_t> divisors;
    map<int64_t, int64_t> index_map;
    for(int i = 0; i < k; i++)
    {
        int64_t tmp;
        cin >> tmp;
        divisors.push_back(tmp);
        index_map[tmp] = i;
    }

    // sort(divisors.begin(), divisors.end());
    int64_t* to_print = new int64_t[n];
    for(auto td : divisors)
    {
        int64_t r = xor_div(td, divisors);
        cout << r << " ";
        //int idx = index_map[r];
        //to_print[idx] = r;
    }
    for(int64_t i = 0; i < k; i++)
    {
        // cout << to_print[i] << " ";
    }
    cout << endl;
    return 0;
}

int64_t xor_div(int64_t i, const vector<int64_t> & pdivs)
{
    int64_t to_div = i;
    vector<int64_t> divisrs;
    for(auto td : pdivs)
    {
        if(td > to_div)
        {
            //break;
        }
        if(to_div % td == 0)
            divisrs.push_back(td);
    }
    int64_t res = 0;
    for(auto td : divisrs)
    {
        res ^= td;
    }
    return res;
}